% This script is the easiest way to use Hippo-ATESC. It runs the entire
% system for all genes in a user-defined training set, then extract the
% most significant features using a genetic algorithm, then uses these
% information to rank all genes in the test set.

% The user must set OUTPUT_FOLDER and the name of EXPERIMENT. Inside the
% folder localized by OUTPUT_FOLDER/EXPERIMENT he needs to put three files:
% EXPERIMENT.train contains the training set
% EXPERIMENT.test contains the test set
% EXPERIMENT.labels contains the labels of the training set
% See the examples given in the Experiments folder to see file format

% The flag DELETE_FOLDERS is used to completely remove an experiment
% (including your previous results, so be careful!). To be sure about the
% complete removal of the folders, close and re-open Matlab.

% ************************ ABSOLUTELY NO WARRANTY ************************

clear all
close all

THIS_DIR = cd;
% folder containing the Genetic Feature Selection Toolbox
GFST_DIR = '../GeneticFeatureSelectionToolbox';

addpath(GFST_DIR)

% SET these two variables according to your needs
OUTPUT_FOLDER = 'C:/Users/Roberto/Desktop/SanPaolo/experiments';
EXPERIMENT = 'example';
% SET true if you want to be sure that a completely new experiment will
% start
DELETE_FOLDERS = true;

% do not modify under this line

RUNNING_ENTIRE_EXPERIMENT = 1;

fprintf('************ STARTING EXPERIMENT %s ************\n\n', EXPERIMENT);

if DELETE_FOLDERS
    exp_folder = strcat(OUTPUT_FOLDER, '/', EXPERIMENT);
    if exist(exp_folder, 'dir')
        fprintf('You are going to remove the folder %s. ', exp_folder);
        confirm = input('Are you sure? [y/n] ', 's');
        if strcmpi(confirm, 'y')
            succ = rmdir(exp_folder, 's');
            if ~succ
                fprintf('\nWARNING!! Some problems occurred while removing folder %s.\nYou can try to manually remove it. ', exp_folder);
                input('When you are done, press Enter');
            end
        end
    end
end

% create training set
IS_TRAINING = 1;
runExperiment

% extract significant features
cd(GFST_DIR)
mainFeatureExtraction
cd(THIS_DIR)

%test
IS_TRAINING = 0;
runExperiment

fprintf('************ EXPERIMENT %s COMPLETE ************\n\n', EXPERIMENT);